#include "util.h"


/*******************************************************************************
* Global Variables
*******************************************************************************/
uint32_t error_counter=0;       // Global error tracker
uint8_t  fail_status=0;         // Global failure status flag

#pragma section NOINIT begin    // Section not modified by runtime code!
uint32_t noinit32[8];           // Non-initialized RAM array (32-bit)
uint16_t noinit16[8];           // Non-initialized RAM array (16-bit)
uint8_t  noinit8[8];            // Non-initialized RAM array (8-bit)
uint32_t exit_portal;           // Write here to end simulations
uint32_t cprint_arg[5];         // C-Print arguments
uint32_t cprint_cmd;            // C-Print command
#pragma section NOINIT end      // Link proceeding variables in default section


/*******************************************************************************
* Testbench notification implementation
*******************************************************************************/
void _notify_tb_caa(command_t command, address_t address, address_t address2)
{
   _NOTIFY_TB_CAA(command, address, address2);
}

void _notify_tb_ca8(command_t command, address_t address, uint8_t data1)
{
   _NOTIFY_TB_CA8(command, address, data1);
}

void _notify_tb_ca16(command_t command, address_t address, uint16_t data1)
{
   _NOTIFY_TB_CA16(command, address, data1);
}

void _notify_tb_ca32(command_t command, address_t address, uint32_t data1)
{
   _NOTIFY_TB_CA32(command, address, data1);
}

void _notify_tb_caa8(command_t command, address_t address, address_t address2, uint8_t data1)
{
   _NOTIFY_TB_CAA8(command, address, address2, data1);
}

void _notify_tb_caa16(command_t command, address_t address, address_t address2, uint16_t data1)
{
   _NOTIFY_TB_CAA16(command, address, address2, data1);
}

void _notify_tb_caa32(command_t command, address_t address, address_t address2, uint32_t data1)
{
   _NOTIFY_TB_CAA32(command, address, address2, data1);
}

void _notify_tb_ca88(command_t command, address_t address, uint8_t data1, uint8_t data2)
{
   _NOTIFY_TB_CA88(command, address, data1, data2);
}

void _notify_tb_ca1616(command_t command, address_t address, uint16_t data1, uint16_t data2)
{
   _NOTIFY_TB_CA1616(command, address, data1, data2);
}

void _notify_tb_ca3232(command_t command, address_t address, uint32_t data1, uint32_t data2)
{
   _NOTIFY_TB_CA3232(command, address, data1, data2);
}

void _notify_tb_ca888(command_t command, address_t address, uint8_t data1, uint8_t data2, uint8_t data3)
{
   _NOTIFY_TB_CA888(command, address, data1, data2, data3);
}

void _notify_tb_ca161616(command_t command, address_t address, uint16_t data1, uint16_t data2, uint16_t data3)
{
   _NOTIFY_TB_CA161616(command, address, data1, data2, data3);
}

void _notify_tb_ca323232(command_t command, address_t address, uint32_t data1, uint32_t data2, uint32_t data3)
{
   _NOTIFY_TB_CA323232(command, address, data1, data2, data3);
}

void _notify_tb_ca8816(command_t command, address_t address, uint8_t data1, uint8_t data2, uint16_t data3)
{
   _NOTIFY_TB_CA8816(command, address, data1, data2, data3);
}

void _notify_tb_ca323216(command_t command, address_t address, uint32_t data1, uint32_t data2, uint16_t data3)
{
   _NOTIFY_TB_CA323216(command, address, data1, data2, data3);
}

void _notify_tb_ca8888(command_t command, address_t address, uint8_t data1, uint8_t data2, uint8_t data3, uint8_t data4)
{
   _NOTIFY_TB_CA8888(command, address, data1, data2, data3, data4);
}

void _notify_tb_ca16161616(command_t command, address_t address, uint16_t data1, uint16_t data2, uint16_t data3, uint16_t data4)
{
   _NOTIFY_TB_CA16161616(command, address, data1, data2, data3, data4);
}

void _notify_tb_ca32323232(command_t command, address_t address, uint32_t data1, uint32_t data2, uint32_t data3, uint32_t data4)
{
   _NOTIFY_TB_CA32323232(command, address, data1, data2, data3, data4);
}

void _notify_tb_ca88816(command_t command, address_t address, uint8_t data1, uint8_t data2, uint8_t data3, uint16_t data4)
{
   _NOTIFY_TB_CA88816(command, address, data1, data2, data3, data4);
}

void _notify_tb_ca32323216(command_t command, address_t address, uint32_t data1, uint32_t data2, uint32_t data3, uint16_t data4)
{
   _NOTIFY_TB_CA32323216(command, address, data1, data2, data3, data4);
}


/*******************************************************************************
* Pass/Fail notification implementation
*******************************************************************************/
void _success(void)
{ 
   _SUCCESS();
}

void _failure(void)
{
   _FAILURE();
}

void _terminate(void)
{
   _TERMINATE();
}


/*******************************************************************************
* Testbench communication implementation
*******************************************************************************/
void _trigger_set(flag_t flag)
{
   _TRIGGER_SET(flag);
}

void _trigger_wait(flag_t flag)
{
   _TRIGGER_WAIT(flag);
}

void _mb_put8(mailbox_t mailbox, uint8_t write_data)
{
   _MB_PUTx(8, mailbox, write_data);
}

void _mb_put16(mailbox_t mailbox, uint16_t write_data)
{
   _MB_PUTx(16, mailbox, write_data);
}

void _mb_put32(mailbox_t mailbox, uint32_t write_data)
{
   _MB_PUTx(32, mailbox, write_data);
}

void _mb_get8(mailbox_t mailbox, uint8_t* destvar)
{
   _MB_GETx(8, mailbox, destvar);
}

void _mb_get16(mailbox_t mailbox, uint16_t* destvar)
{
   _MB_GETx(16, mailbox, destvar);
}

void _mb_get32(mailbox_t mailbox, uint32_t* destvar)
{
   _MB_GETx(32, mailbox, destvar);
}

void _debug(char* source, char* comment)
{ 
   _DEBUG(source, comment);
}

void _trace(char* source, char* comment)
{
   _TRACE(source, comment);
}

void _info(char* source, char* comment)
{
   _INFO(source, comment);
}

void _warn(char* source, char* comment)
{
   _WARN(source, comment);
}

void _error(char* source, char* comment)
{
   _ERROR(source, comment);
}

void _fatal(char* source, char* comment)
{
   _FATAL(source, comment);
}

void _show8(char* source, char* comment, uint8_t value)
{ 
   _SHOW8(source, comment, value);
}

void _show16(char* source, char* comment, uint16_t value)
{ 
   _SHOW16(source, comment, value);
}

void _show32(char* source, char* comment, uint32_t value)
{
   _SHOW32(source, comment, value);
}


/*******************************************************************************
* C API Definition (8-bit)
*******************************************************************************/
void _r8(vuint8_t* address, uint8_t* destvar)
{
   _R8(address, destvar);
}

void _re8(vuint8_t* address, uint8_t expect_data)
{
   _RE8(address, expect_data);
}

void _rem8(vuint8_t* address, uint8_t expect_data, uint8_t mask)
{
   _REM8(address, expect_data, mask);
}

void _rre8(vuint8_t* address, vuint8_t* destvar, uint8_t expect_data)
{
   _RRE8(address, destvar, expect_data);
}

void _rrem8(vuint8_t* address, vuint8_t* destvar, uint8_t expect_data, uint8_t mask)
{
   _RREM8(address, destvar, expect_data, mask);
}

void _w8(vuint8_t* address, uint8_t write_data)
{
   _W8(address, write_data);
}

void _wr8(vuint8_t* address, uint8_t write_data)
{
   _WR8(address, write_data);
}

void _wrm8(vuint8_t* address, uint8_t write_data, uint8_t mask)
{
   _WRM8(address, write_data, mask);
}

void _wre8(vuint8_t* address, uint8_t write_data, uint8_t expect_data)
{
   _WRE8(address, write_data, expect_data);
}

void _wrem8(vuint8_t* address, uint8_t write_data, uint8_t expect_data, uint8_t mask)
{
   _WREM8(address, write_data, expect_data, mask);
}

void _wait_re8(vuint8_t* address, uint8_t expect_data, uint16_t read_attempts)
{
   _WAIT_RE8(address, expect_data, read_attempts);
}

void _wait_rem8(vuint8_t* address, uint8_t expect_data, uint8_t mask, uint16_t read_attempts)
{
   _WAIT_REM8(address, expect_data, mask, read_attempts);
}

void _bset8(vuint8_t* address, uint8_t mask)
{
   _BSET8(address, mask);
}

void _bclr8(vuint8_t* address, uint8_t mask)
{
   _BCLR8(address, mask);
}

void _binv8(vuint8_t* address, uint8_t mask)
{
   _BINV8(address, mask);
}


/*******************************************************************************
* C API Definition (16-bit)
*******************************************************************************/
void _r16(vuint16_t* address, uint16_t* destvar)
{ 
   _R16(address, destvar);
}

void _re16(vuint16_t* address, uint16_t expect_data)
{
   _RE16(address, expect_data);
}

void _rem16(vuint16_t* address, uint16_t expect_data, uint16_t mask)
{
   _REM16(address, expect_data, mask);
}

void _rre16(vuint16_t* address, vuint16_t* destvar, uint16_t expect_data)
{
   _RRE16(address, destvar, expect_data);
}

void _rrem16(vuint16_t* address, vuint16_t* destvar, uint16_t expect_data, uint16_t mask)
{
   _RREM16(address, destvar, expect_data, mask);
}

void _w16(vuint16_t* address, uint16_t write_data)
{
   _W16(address, write_data);
}

void _wr16(vuint16_t* address, uint16_t write_data)
{
   _WR16(address, write_data);
}

void _wrm16(vuint16_t* address, uint16_t write_data, uint16_t mask)
{
   _WRM16(address, write_data, mask);
}

void _wre16(vuint16_t* address, uint16_t write_data, uint16_t expect_data)
{
   _WRE16(address, write_data, expect_data);
}

void _wrem16(vuint16_t* address, uint16_t write_data, uint16_t expect_data, uint16_t mask)
{
   _WREM16(address, write_data, expect_data, mask);
}

void _wait_re16(vuint16_t* address, uint16_t expect_data, uint16_t read_attempts)
{
   _WAIT_RE16(address, expect_data, read_attempts);
}

void _wait_rem16(vuint16_t* address, uint16_t expect_data, uint16_t mask, uint16_t read_attempts)
{
   _WAIT_REM16(address, expect_data, mask, read_attempts);
}

void _bset16(vuint16_t* address, uint16_t mask)
{
   _BSET16(address, mask);
}

void _bclr16(vuint16_t* address, uint16_t mask)
{
   _BCLR16(address, mask);
}

void _binv16(vuint16_t* address, uint16_t mask)
{
   _BINV16(address, mask);
}


/*******************************************************************************
* C API Definition (32-bit)
*******************************************************************************/
void _r32(vuint32_t* address, uint32_t* destvar)
{
   _R32(address, destvar);
}

void _re32(vuint32_t* address, uint32_t expect_data)
{
   _RE32(address, expect_data);
}

void _rem32(vuint32_t* address, uint32_t expect_data, uint32_t mask)
{
   _REM32(address, expect_data, mask);
}

void _rre32(vuint32_t* address, vuint32_t* destvar, uint32_t expect_data)
{
   _RRE32(address, destvar, expect_data);
}

void _rrem32(vuint32_t* address, vuint32_t* destvar, uint32_t expect_data, uint32_t mask)
{
   _RREM32(address, destvar, expect_data, mask);
}

void _w32(vuint32_t* address, uint32_t write_data)
{
   _W32(address, write_data);
}

void _wr32(vuint32_t* address, uint32_t write_data)
{
   _WR32(address, write_data);
}

void _wrm32(vuint32_t* address, uint32_t write_data, uint32_t mask)
{
   _WRM32(address, write_data, mask);
}

void _wre32(vuint32_t* address, uint32_t write_data, uint32_t expect_data)
{
   _WRE32(address, write_data, expect_data);
}

void _wrem32(vuint32_t* address, uint32_t write_data, uint32_t expect_data, uint32_t mask)
{
   _WREM32(address, write_data, expect_data, mask);
}

void _wait_re32(vuint32_t* address, uint32_t expect_data, uint16_t read_attempts)
{
   _WAIT_RE32(address, expect_data, read_attempts);
}

void _wait_rem32(vuint32_t* address, uint32_t expect_data, uint32_t mask, uint16_t read_attempts)
{
   _WAIT_REM32(address, expect_data, mask, read_attempts);
}

void _bset32(vuint32_t* address, uint32_t mask)
{
   _BSET32(address, mask);
}

void _bclr32(vuint32_t* address, uint32_t mask)
{
   _BCLR32(address, mask);
}

void _binv32(vuint32_t* address, uint32_t mask)
{
   _BINV32(address, mask);
}


/* End of "mcd_c_api.c" */
